﻿#pragma once

namespace RTCam {

class Scene;
class Camera;
class Entity;

class RTSimulation final 
{
public:
	RTSimulation(void);
	~RTSimulation(void);
	
	// Called before each frame is rendered, before RTCamera's RenderUpdate
	void RenderUpdate(const shared_ptr<Scene>& scene, float curTime, float delta);
	// Called once every physics timestep
	void FixedUpdate(const shared_ptr<Scene>& scene, float curTime, float delta);

	void MoveCameraForward(const shared_ptr<Camera>& camera);
	void MoveCameraBack(const shared_ptr<Camera>& camera);
	void MoveCameraRight(const shared_ptr<Camera>& camera);
	void MoveCameraLeft(const shared_ptr<Camera>& camera);
	void MoveCameraUp(const shared_ptr<Camera>& camera);
	void MoveCameraDown(const shared_ptr<Camera>& camera);
	void TurnCameraLeft(const shared_ptr<Camera>& camera);
	void TurnCameraRight(const shared_ptr<Camera>& camera);
	
private:
	void UpdateModelCBufferDatas(const shared_ptr<Entity>& e);
	
	void UpdateCameraAnimations(const shared_ptr<Scene>& scene, float curTime, float delta);
};

} // end namespace